/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.GraphErrorCodes;
import com.microsoft.graph.http.DefaultHttpProvider;
import com.microsoft.graph.http.GraphError;
import com.microsoft.graph.http.GraphErrorResponse;
import com.microsoft.graph.http.GraphFatalServiceException;
import com.microsoft.graph.http.GraphInnerError;
import com.microsoft.graph.http.IConnection;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.serializer.ISerializer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class GraphServiceException
extends ClientException {
    protected static final char NEW_LINE = '\n';
    protected static final String TRUNCATION_MARKER = "[...]";
    protected static final int MAX_BREVITY_LENGTH = 50;
    protected static final int MAX_BYTE_COUNT_BEFORE_TRUNCATION = 8;
    public static final int INDENT_SPACES = 3;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private final GraphErrorResponse mError;
    private final String mMethod;
    private final String mUrl;
    private final List<String> mRequestHeaders;
    private final String mRequestBody;
    private final int mResponseCode;
    private final String mResponseMessage;
    private final List<String> mResponseHeaders;

    protected GraphServiceException(String method, String url, List<String> requestHeaders, String requestBody, int responseCode, String responseMessage, List<String> responseHeaders, GraphErrorResponse error) {
        super(responseMessage, null, null);
        this.mMethod = method;
        this.mUrl = url;
        this.mRequestHeaders = requestHeaders;
        this.mRequestBody = requestBody;
        this.mResponseCode = responseCode;
        this.mResponseMessage = responseMessage;
        this.mResponseHeaders = responseHeaders;
        this.mError = error;
    }

    @Override
    public String getMessage() {
        return this.getMessage(false);
    }

    public String getMessage(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (this.mError != null && this.mError.error != null) {
            sb.append("Error code: ").append(this.mError.error.code).append('\n');
            sb.append("Error message: ").append(this.mError.error.message).append('\n');
            sb.append('\n');
        }
        sb.append(this.mMethod).append(' ').append(this.mUrl).append('\n');
        for (String header : this.mRequestHeaders) {
            if (verbose) {
                sb.append(header);
            } else {
                String truncatedHeader = header.substring(0, Math.min(50, header.length()));
                sb.append(truncatedHeader);
                if (truncatedHeader.length() == 50) {
                    sb.append(TRUNCATION_MARKER);
                }
            }
            sb.append('\n');
        }
        if (this.mRequestBody != null) {
            if (verbose) {
                sb.append(this.mRequestBody);
            } else {
                int bodyLength = Math.min(50, this.mRequestBody.length());
                String truncatedBody = this.mRequestBody.substring(0, bodyLength);
                sb.append(truncatedBody);
                if (truncatedBody.length() == 50) {
                    sb.append(TRUNCATION_MARKER);
                }
            }
        }
        sb.append('\n').append('\n');
        sb.append(this.mResponseCode).append(" : ").append(this.mResponseMessage).append('\n');
        for (String header : this.mResponseHeaders) {
            if (verbose) {
                sb.append(header).append('\n');
                continue;
            }
            if (!header.toLowerCase(Locale.ROOT).startsWith("x-throwsite")) continue;
            sb.append(header).append('\n');
        }
        if (verbose && this.mError != null && this.mError.rawObject != null) {
            try {
                JSONObject jsonObject = new JSONObject(this.mError.rawObject.toString());
                sb.append(jsonObject.toString(3)).append('\n');
            }
            catch (JSONException ignored) {
                sb.append("[Warning: Unable to parse error message body]").append('\n');
            }
        } else {
            sb.append(TRUNCATION_MARKER).append('\n').append('\n');
            sb.append("[Some information was truncated for brevity, enable debug logging for more details]");
        }
        return sb.toString();
    }

    public GraphError getServiceError() {
        return this.mError.error;
    }

    @Override
    public boolean isError(GraphErrorCodes expectedCode) {
        if (this.getServiceError() != null) {
            return this.getServiceError().isError(expectedCode);
        }
        return false;
    }

    public static <T> GraphServiceException createFromConnection(IHttpRequest request, T serializable, ISerializer serializer, IConnection connection) throws IOException {
        GraphErrorResponse error;
        String requestBody;
        String method = connection.getRequestMethod();
        String url = request.getRequestUrl().toString();
        LinkedList<String> requestHeaders = new LinkedList<String>();
        for (HeaderOption option : request.getHeaders()) {
            requestHeaders.add(option.getName() + " : " + option.getValue());
        }
        if (serializable instanceof byte[]) {
            byte[] bytes = (byte[])serializable;
            StringBuilder sb = new StringBuilder();
            sb.append("byte[").append(bytes.length).append("]");
            sb.append(" {");
            for (int i = 0; i < 8 && i < bytes.length; ++i) {
                sb.append(bytes[i]).append(", ");
            }
            if (bytes.length > 8) {
                sb.append(TRUNCATION_MARKER).append("}");
            }
            requestBody = sb.toString();
        } else {
            requestBody = serializable != null ? serializer.serializeObject(serializable) : null;
        }
        int responseCode = connection.getResponseCode();
        LinkedList<String> responseHeaders = new LinkedList<String>();
        Map<String, String> headers = connection.getHeaders();
        for (String key : headers.keySet()) {
            String fieldPrefix = key == null ? "" : key + " : ";
            responseHeaders.add(fieldPrefix + headers.get(key));
        }
        String responseMessage = connection.getResponseMessage();
        String rawOutput = DefaultHttpProvider.streamToString(connection.getInputStream());
        try {
            error = serializer.deserializeObject(rawOutput, GraphErrorResponse.class);
        }
        catch (Exception ex) {
            error = new GraphErrorResponse();
            error.error = new GraphError();
            error.error.code = "Unable to parse error response message";
            error.error.message = "Raw error: " + rawOutput;
            error.error.innererror = new GraphInnerError();
            error.error.innererror.code = ex.getMessage();
        }
        if (responseCode >= 500) {
            return new GraphFatalServiceException(method, url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error);
        }
        return new GraphServiceException(method, url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error);
    }
}

