/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.net.URL;
import java.util.List;

public abstract class BaseCollectionRequest<T1, T2>
implements IHttpRequest {
    private final BaseRequest mBaseRequest;
    private final Class<T1> mResponseClass;
    private final Class<T2> mCollectionPageClass;

    public BaseCollectionRequest(String requestUrl, IBaseClient client, List<Option> options, Class<T1> responseClass, Class<T2> collectionPageClass) {
        this.mResponseClass = responseClass;
        this.mCollectionPageClass = collectionPageClass;
        this.mBaseRequest = new BaseRequest(requestUrl, client, options, this.mResponseClass){};
    }

    protected T1 send() throws ClientException {
        this.mBaseRequest.setHttpMethod(HttpMethod.GET);
        return this.mBaseRequest.getClient().getHttpProvider().send(this, this.mResponseClass, null);
    }

    protected <T1, T2> T1 post(T2 serializedObject) throws ClientException {
        this.mBaseRequest.setHttpMethod(HttpMethod.POST);
        return this.mBaseRequest.getClient().getHttpProvider().send(this, this.mResponseClass, serializedObject);
    }

    @Override
    public URL getRequestUrl() {
        return this.mBaseRequest.getRequestUrl();
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.mBaseRequest.getHttpMethod();
    }

    @Override
    public List<HeaderOption> getHeaders() {
        return this.mBaseRequest.getHeaders();
    }

    @Override
    public void addHeader(String header, String value) {
        this.mBaseRequest.addHeader(header, value);
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.mBaseRequest.setUseCaches(useCaches);
    }

    @Override
    public boolean getUseCaches() {
        return this.mBaseRequest.getUseCaches();
    }

    @Override
    public List<Option> getOptions() {
        return this.mBaseRequest.getOptions();
    }

    public void addQueryOption(QueryOption option) {
        this.mBaseRequest.getQueryOptions().add(option);
    }

    public void addFunctionOption(FunctionOption option) {
        this.mBaseRequest.getFunctionOptions().add(option);
    }

    protected BaseRequest getBaseRequest() {
        return this.mBaseRequest;
    }

    public Class<T2> getCollectionPageClass() {
        return this.mCollectionPageClass;
    }
}

