/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookChartPointCollectionPage;
import com.microsoft.graph.extensions.IWorkbookChartPointCollectionRequest;
import com.microsoft.graph.extensions.WorkbookChartPoint;
import com.microsoft.graph.extensions.WorkbookChartPointCollectionPage;
import com.microsoft.graph.extensions.WorkbookChartPointCollectionRequest;
import com.microsoft.graph.extensions.WorkbookChartPointCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookChartPointRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookChartPointCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookChartPointCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookChartPointCollectionRequest
extends BaseCollectionRequest<BaseWorkbookChartPointCollectionResponse, IWorkbookChartPointCollectionPage>
implements IBaseWorkbookChartPointCollectionRequest {
    public BaseWorkbookChartPointCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookChartPointCollectionResponse.class, IWorkbookChartPointCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookChartPointCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookChartPointCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookChartPointCollectionPage get() throws ClientException {
        BaseWorkbookChartPointCollectionResponse response = (BaseWorkbookChartPointCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookChartPoint newWorkbookChartPoint, ICallback<WorkbookChartPoint> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookChartPointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookChartPoint, callback);
    }

    @Override
    public WorkbookChartPoint post(WorkbookChartPoint newWorkbookChartPoint) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookChartPointRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newWorkbookChartPoint);
    }

    @Override
    public IWorkbookChartPointCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookChartPointCollectionRequest)this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookChartPointCollectionRequest)this;
    }

    @Override
    public IWorkbookChartPointCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookChartPointCollectionRequest)this;
    }

    public IWorkbookChartPointCollectionPage buildFromResponse(BaseWorkbookChartPointCollectionResponse response) {
        WorkbookChartPointCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookChartPointCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookChartPointCollectionPage page = new WorkbookChartPointCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

