/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ISubscriptionCollectionPage;
import com.microsoft.graph.extensions.ISubscriptionCollectionRequest;
import com.microsoft.graph.extensions.Subscription;
import com.microsoft.graph.extensions.SubscriptionCollectionPage;
import com.microsoft.graph.extensions.SubscriptionCollectionRequest;
import com.microsoft.graph.extensions.SubscriptionCollectionRequestBuilder;
import com.microsoft.graph.extensions.SubscriptionRequestBuilder;
import com.microsoft.graph.generated.BaseSubscriptionCollectionResponse;
import com.microsoft.graph.generated.IBaseSubscriptionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseSubscriptionCollectionRequest
extends BaseCollectionRequest<BaseSubscriptionCollectionResponse, ISubscriptionCollectionPage>
implements IBaseSubscriptionCollectionRequest {
    public BaseSubscriptionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseSubscriptionCollectionResponse.class, ISubscriptionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISubscriptionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseSubscriptionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISubscriptionCollectionPage get() throws ClientException {
        BaseSubscriptionCollectionResponse response = (BaseSubscriptionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Subscription newSubscription, ICallback<Subscription> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SubscriptionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscription, callback);
    }

    @Override
    public Subscription post(Subscription newSubscription) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SubscriptionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newSubscription);
    }

    @Override
    public ISubscriptionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (SubscriptionCollectionRequest)this;
    }

    @Override
    public ISubscriptionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (SubscriptionCollectionRequest)this;
    }

    @Override
    public ISubscriptionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (SubscriptionCollectionRequest)this;
    }

    public ISubscriptionCollectionPage buildFromResponse(BaseSubscriptionCollectionResponse response) {
        SubscriptionCollectionRequestBuilder builder = response.nextLink != null ? new SubscriptionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SubscriptionCollectionPage page = new SubscriptionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

