/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IOnenotePageCollectionPage;
import com.microsoft.graph.extensions.IOnenotePageCollectionRequest;
import com.microsoft.graph.extensions.OnenotePage;
import com.microsoft.graph.extensions.OnenotePageCollectionPage;
import com.microsoft.graph.extensions.OnenotePageCollectionRequest;
import com.microsoft.graph.extensions.OnenotePageCollectionRequestBuilder;
import com.microsoft.graph.extensions.OnenotePageRequestBuilder;
import com.microsoft.graph.generated.BaseOnenotePageCollectionResponse;
import com.microsoft.graph.generated.IBaseOnenotePageCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseOnenotePageCollectionRequest
extends BaseCollectionRequest<BaseOnenotePageCollectionResponse, IOnenotePageCollectionPage>
implements IBaseOnenotePageCollectionRequest {
    public BaseOnenotePageCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseOnenotePageCollectionResponse.class, IOnenotePageCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOnenotePageCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseOnenotePageCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOnenotePageCollectionPage get() throws ClientException {
        BaseOnenotePageCollectionResponse response = (BaseOnenotePageCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(byte[] newOnenotePage, ICallback<OnenotePage> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OnenotePageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenotePage, callback);
    }

    @Override
    public OnenotePage post(byte[] newOnenotePage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OnenotePageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newOnenotePage);
    }

    @Override
    public IOnenotePageCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (OnenotePageCollectionRequest)this;
    }

    @Override
    public IOnenotePageCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (OnenotePageCollectionRequest)this;
    }

    @Override
    public IOnenotePageCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (OnenotePageCollectionRequest)this;
    }

    public IOnenotePageCollectionPage buildFromResponse(BaseOnenotePageCollectionResponse response) {
        OnenotePageCollectionRequestBuilder builder = response.nextLink != null ? new OnenotePageCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OnenotePageCollectionPage page = new OnenotePageCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

