/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.GroupSettingTemplate;
import com.microsoft.graph.extensions.GroupSettingTemplateCollectionPage;
import com.microsoft.graph.extensions.GroupSettingTemplateCollectionRequest;
import com.microsoft.graph.extensions.GroupSettingTemplateCollectionRequestBuilder;
import com.microsoft.graph.extensions.GroupSettingTemplateRequestBuilder;
import com.microsoft.graph.extensions.IGroupSettingTemplateCollectionPage;
import com.microsoft.graph.extensions.IGroupSettingTemplateCollectionRequest;
import com.microsoft.graph.generated.BaseGroupSettingTemplateCollectionResponse;
import com.microsoft.graph.generated.IBaseGroupSettingTemplateCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseGroupSettingTemplateCollectionRequest
extends BaseCollectionRequest<BaseGroupSettingTemplateCollectionResponse, IGroupSettingTemplateCollectionPage>
implements IBaseGroupSettingTemplateCollectionRequest {
    public BaseGroupSettingTemplateCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseGroupSettingTemplateCollectionResponse.class, IGroupSettingTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IGroupSettingTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseGroupSettingTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingTemplateCollectionPage get() throws ClientException {
        BaseGroupSettingTemplateCollectionResponse response = (BaseGroupSettingTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSettingTemplate newGroupSettingTemplate, ICallback<GroupSettingTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSettingTemplate, callback);
    }

    @Override
    public GroupSettingTemplate post(GroupSettingTemplate newGroupSettingTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newGroupSettingTemplate);
    }

    @Override
    public IGroupSettingTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (GroupSettingTemplateCollectionRequest)this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (GroupSettingTemplateCollectionRequest)this;
    }

    @Override
    public IGroupSettingTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (GroupSettingTemplateCollectionRequest)this;
    }

    public IGroupSettingTemplateCollectionPage buildFromResponse(BaseGroupSettingTemplateCollectionResponse response) {
        GroupSettingTemplateCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingTemplateCollectionPage page = new GroupSettingTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

