/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Extension;
import com.microsoft.graph.extensions.ExtensionCollectionPage;
import com.microsoft.graph.extensions.ExtensionCollectionRequest;
import com.microsoft.graph.extensions.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.extensions.ExtensionRequestBuilder;
import com.microsoft.graph.extensions.IExtensionCollectionPage;
import com.microsoft.graph.extensions.IExtensionCollectionRequest;
import com.microsoft.graph.generated.BaseExtensionCollectionResponse;
import com.microsoft.graph.generated.IBaseExtensionCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseExtensionCollectionRequest
extends BaseCollectionRequest<BaseExtensionCollectionResponse, IExtensionCollectionPage>
implements IBaseExtensionCollectionRequest {
    public BaseExtensionCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseExtensionCollectionResponse.class, IExtensionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IExtensionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseExtensionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IExtensionCollectionPage get() throws ClientException {
        BaseExtensionCollectionResponse response = (BaseExtensionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Extension newExtension, ICallback<Extension> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newExtension, callback);
    }

    @Override
    public Extension post(Extension newExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newExtension);
    }

    @Override
    public IExtensionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ExtensionCollectionRequest)this;
    }

    @Override
    public IExtensionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ExtensionCollectionRequest)this;
    }

    @Override
    public IExtensionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ExtensionCollectionRequest)this;
    }

    public IExtensionCollectionPage buildFromResponse(BaseExtensionCollectionResponse response) {
        ExtensionCollectionRequestBuilder builder = response.nextLink != null ? new ExtensionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ExtensionCollectionPage page = new ExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

