// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Onenote Operation.
 */
public class BaseOnenoteOperation extends Operation implements IJsonBackedObject {


    public BaseOnenoteOperation() {
        oDataType = "microsoft.graph.onenoteOperation";
    }

    /**
     * The Resource Location.
     * The resource URI for the object. For example, the resource URI for a copied page or section.
     */
    @SerializedName("resourceLocation")
    @Expose
    public String resourceLocation;

    /**
     * The Resource Id.
     * The resource id.
     */
    @SerializedName("resourceId")
    @Expose
    public String resourceId;

    /**
     * The Error.
     * The error returned by the operation.
     */
    @SerializedName("error")
    @Expose
    public OnenoteOperationError error;

    /**
     * The Percent Complete.
     * The operation percent complete if the operation is still in running status
     */
    @SerializedName("percentComplete")
    @Expose
    public String percentComplete;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
