// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Directory Object Get Member Objects Collection Request.
 */
public class BaseDirectoryObjectGetMemberObjectsCollectionRequest extends BaseCollectionRequest<BaseDirectoryObjectGetMemberObjectsCollectionResponse, IDirectoryObjectGetMemberObjectsCollectionPage> implements IBaseDirectoryObjectGetMemberObjectsCollectionRequest {


    protected final DirectoryObjectGetMemberObjectsBody mBody;


    /**
     * The request for this DirectoryObjectGetMemberObjects
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDirectoryObjectGetMemberObjectsCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseDirectoryObjectGetMemberObjectsCollectionResponse.class, IDirectoryObjectGetMemberObjectsCollectionPage.class);
        mBody = new DirectoryObjectGetMemberObjectsBody();
    }


    public void post(final ICallback<IDirectoryObjectGetMemberObjectsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(post(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDirectoryObjectGetMemberObjectsCollectionPage post() throws ClientException {
        final BaseDirectoryObjectGetMemberObjectsCollectionResponse response = post(mBody);
        return buildFromResponse(response);
    }


    public IDirectoryObjectGetMemberObjectsCollectionPage buildFromResponse(final BaseDirectoryObjectGetMemberObjectsCollectionResponse response) {
        final IDirectoryObjectGetMemberObjectsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DirectoryObjectGetMemberObjectsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, /* securityEnabledOnly */ null);
        } else {
            builder = null;
        }
        final IDirectoryObjectGetMemberObjectsCollectionPage page = new DirectoryObjectGetMemberObjectsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IDirectoryObjectGetMemberObjectsCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IDirectoryObjectGetMemberObjectsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IDirectoryObjectGetMemberObjectsCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (IDirectoryObjectGetMemberObjectsCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IDirectoryObjectGetMemberObjectsCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IDirectoryObjectGetMemberObjectsCollectionRequest)this;
    }

}
