// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Column Definition.
 */
public class BaseColumnDefinition extends Entity implements IJsonBackedObject {


    public BaseColumnDefinition() {
        oDataType = "microsoft.graph.columnDefinition";
    }

    /**
     * The Boolean.
     * 
     */
    @SerializedName("boolean")
    @Expose
    public BooleanColumn msgraph_boolean;

    /**
     * The Calculated.
     * 
     */
    @SerializedName("calculated")
    @Expose
    public CalculatedColumn calculated;

    /**
     * The Choice.
     * 
     */
    @SerializedName("choice")
    @Expose
    public ChoiceColumn choice;

    /**
     * The Column Group.
     * 
     */
    @SerializedName("columnGroup")
    @Expose
    public String columnGroup;

    /**
     * The Currency.
     * 
     */
    @SerializedName("currency")
    @Expose
    public CurrencyColumn currency;

    /**
     * The Date Time.
     * 
     */
    @SerializedName("dateTime")
    @Expose
    public DateTimeColumn dateTime;

    /**
     * The Default Value.
     * 
     */
    @SerializedName("defaultValue")
    @Expose
    public DefaultColumnValue defaultValue;

    /**
     * The Description.
     * 
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Display Name.
     * 
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Enforce Unique Values.
     * 
     */
    @SerializedName("enforceUniqueValues")
    @Expose
    public Boolean enforceUniqueValues;

    /**
     * The Hidden.
     * 
     */
    @SerializedName("hidden")
    @Expose
    public Boolean hidden;

    /**
     * The Indexed.
     * 
     */
    @SerializedName("indexed")
    @Expose
    public Boolean indexed;

    /**
     * The Lookup.
     * 
     */
    @SerializedName("lookup")
    @Expose
    public LookupColumn lookup;

    /**
     * The Name.
     * 
     */
    @SerializedName("name")
    @Expose
    public String name;

    /**
     * The Number.
     * 
     */
    @SerializedName("number")
    @Expose
    public NumberColumn number;

    /**
     * The Person Or Group.
     * 
     */
    @SerializedName("personOrGroup")
    @Expose
    public PersonOrGroupColumn personOrGroup;

    /**
     * The Read Only.
     * 
     */
    @SerializedName("readOnly")
    @Expose
    public Boolean readOnly;

    /**
     * The Required.
     * 
     */
    @SerializedName("required")
    @Expose
    public Boolean required;

    /**
     * The Text.
     * 
     */
    @SerializedName("text")
    @Expose
    public TextColumn text;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;

    }
}
