// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Onenote Resource Request.
 */
public interface IBaseOnenoteResourceRequest extends IHttpRequest {

    /**
     * Gets the OnenoteResource from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<OnenoteResource> callback);

    /**
     * Gets the OnenoteResource from the service
     * @return The OnenoteResource from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteResource get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OnenoteResource with a source
     * @param sourceOnenoteResource The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final OnenoteResource sourceOnenoteResource, final ICallback<OnenoteResource> callback);

    /**
     * Patches this OnenoteResource with a source
     * @param sourceOnenoteResource The source object with updates
     * @return The updated OnenoteResource
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteResource patch(final OnenoteResource sourceOnenoteResource) throws ClientException;

    /**
     * Posts a OnenoteResource with a new object
     * @param newOnenoteResource The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final OnenoteResource newOnenoteResource, final ICallback<OnenoteResource> callback);

    /**
     * Posts a OnenoteResource with a new object
     * @param newOnenoteResource The new object to create
     * @return The created OnenoteResource
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OnenoteResource post(final OnenoteResource newOnenoteResource) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseOnenoteResourceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseOnenoteResourceRequest expand(final String value);

}
