// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Domain Dns Unavailable Record Request.
 */
public interface IBaseDomainDnsUnavailableRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<DomainDnsUnavailableRecord> callback);

    /**
     * Gets the DomainDnsUnavailableRecord from the service
     * @return The DomainDnsUnavailableRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsUnavailableRecord get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     * @param sourceDomainDnsUnavailableRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord, final ICallback<DomainDnsUnavailableRecord> callback);

    /**
     * Patches this DomainDnsUnavailableRecord with a source
     * @param sourceDomainDnsUnavailableRecord The source object with updates
     * @return The updated DomainDnsUnavailableRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsUnavailableRecord patch(final DomainDnsUnavailableRecord sourceDomainDnsUnavailableRecord) throws ClientException;

    /**
     * Posts a DomainDnsUnavailableRecord with a new object
     * @param newDomainDnsUnavailableRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord, final ICallback<DomainDnsUnavailableRecord> callback);

    /**
     * Posts a DomainDnsUnavailableRecord with a new object
     * @param newDomainDnsUnavailableRecord The new object to create
     * @return The created DomainDnsUnavailableRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsUnavailableRecord post(final DomainDnsUnavailableRecord newDomainDnsUnavailableRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseDomainDnsUnavailableRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseDomainDnsUnavailableRecordRequest expand(final String value);

}
