// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Mail Folder Delta Collection Request.
 */
public class BaseMailFolderDeltaCollectionRequest extends BaseCollectionRequest<BaseMailFolderDeltaCollectionResponse, IMailFolderDeltaCollectionPage> implements IBaseMailFolderDeltaCollectionRequest {


    /**
     * The request for this MailFolderDelta
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseMailFolderDeltaCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMailFolderDeltaCollectionResponse.class, IMailFolderDeltaCollectionPage.class);
    }


    public void get(final ICallback<IMailFolderDeltaCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IMailFolderDeltaCollectionPage get() throws ClientException {
        final BaseMailFolderDeltaCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IMailFolderDeltaCollectionPage buildFromResponse(final BaseMailFolderDeltaCollectionResponse response) {
        final IMailFolderDeltaCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new MailFolderDeltaCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final IMailFolderDeltaCollectionPage page = new MailFolderDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IMailFolderDeltaCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IMailFolderDeltaCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IMailFolderDeltaCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (IMailFolderDeltaCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IMailFolderDeltaCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IMailFolderDeltaCollectionRequest)this;
    }

}
