// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Group Setting Template Request.
 */
public class BaseGroupSettingTemplateRequest extends BaseRequest implements IBaseGroupSettingTemplateRequest {

    /**
     * The request for the GroupSettingTemplate
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseGroupSettingTemplateRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the GroupSettingTemplate from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the GroupSettingTemplate from the service
     * @return The GroupSettingTemplate from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public GroupSettingTemplate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this GroupSettingTemplate with a source
     * @param sourceGroupSettingTemplate The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final GroupSettingTemplate sourceGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.PATCH, callback, sourceGroupSettingTemplate);
    }

    /**
     * Patches this GroupSettingTemplate with a source
     * @param sourceGroupSettingTemplate The source object with updates
     * @return The updated GroupSettingTemplate
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public GroupSettingTemplate patch(final GroupSettingTemplate sourceGroupSettingTemplate) throws ClientException {
        return send(HttpMethod.PATCH, sourceGroupSettingTemplate);
    }

    /**
     * Creates a GroupSettingTemplate with a new object
     * @param newGroupSettingTemplate The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final GroupSettingTemplate newGroupSettingTemplate, final ICallback<GroupSettingTemplate> callback) {
        send(HttpMethod.POST, callback, newGroupSettingTemplate);
    }

    /**
     * Creates a GroupSettingTemplate with a new object
     * @param newGroupSettingTemplate The new object to create
     * @return The created GroupSettingTemplate
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public GroupSettingTemplate post(final GroupSettingTemplate newGroupSettingTemplate) throws ClientException {
        return send(HttpMethod.POST, newGroupSettingTemplate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IGroupSettingTemplateRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (GroupSettingTemplateRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IGroupSettingTemplateRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (GroupSettingTemplateRequest)this;
     }

}
