// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Dns Record Request Builder.
 */
public class BaseDomainDnsRecordRequestBuilder extends BaseRequestBuilder implements IBaseDomainDnsRecordRequestBuilder {

    /**
     * The request builder for the DomainDnsRecord
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDomainDnsRecordRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IDomainDnsRecordRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IDomainDnsRecordRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new DomainDnsRecordRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IDomainDnsCnameRecordRequestBuilder domainDnsCnameRecord() {
        return new DomainDnsCnameRecordRequestBuilder(getRequestUrlWithAdditionalSegment("domainDnsCnameRecord"), getClient(), null);
    }

    public IDomainDnsMxRecordRequestBuilder domainDnsMxRecord() {
        return new DomainDnsMxRecordRequestBuilder(getRequestUrlWithAdditionalSegment("domainDnsMxRecord"), getClient(), null);
    }

    public IDomainDnsSrvRecordRequestBuilder domainDnsSrvRecord() {
        return new DomainDnsSrvRecordRequestBuilder(getRequestUrlWithAdditionalSegment("domainDnsSrvRecord"), getClient(), null);
    }

    public IDomainDnsTxtRecordRequestBuilder domainDnsTxtRecord() {
        return new DomainDnsTxtRecordRequestBuilder(getRequestUrlWithAdditionalSegment("domainDnsTxtRecord"), getClient(), null);
    }

    public IDomainDnsUnavailableRecordRequestBuilder domainDnsUnavailableRecord() {
        return new DomainDnsUnavailableRecordRequestBuilder(getRequestUrlWithAdditionalSegment("domainDnsUnavailableRecord"), getClient(), null);
    }
}
