// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Border Collection Request Builder.
 */
public class BaseWorkbookRangeBorderCollectionRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookRangeBorderCollectionRequestBuilder {

    /**
     * The request builder for this collection of WorkbookRangeFormat
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookRangeBorderCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IWorkbookRangeBorderCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IWorkbookRangeBorderCollectionRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new WorkbookRangeBorderCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IWorkbookRangeBorderRequestBuilder byId(final String id) {
        return new WorkbookRangeBorderRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IWorkbookRangeBorderItemAtRequestBuilder getItemAt(final Integer index) {
        return new WorkbookRangeBorderItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, index);
    }

    public IWorkbookRangeBorderCountRequestBuilder getCount() {
        return new WorkbookRangeBorderCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }
}
