// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Device.
 */
public class BaseDevice extends DirectoryObject implements IJsonBackedObject {


    public BaseDevice() {
        oDataType = "microsoft.graph.device";
    }

    /**
     * The Account Enabled.
	 * 
     */
    @SerializedName("accountEnabled")
    @Expose
    public Boolean accountEnabled;

    /**
     * The Alternative Security Ids.
	 * 
     */
    @SerializedName("alternativeSecurityIds")
    @Expose
    public java.util.List<AlternativeSecurityId> alternativeSecurityIds;

    /**
     * The Approximate Last Sign In Date Time.
	 * 
     */
    @SerializedName("approximateLastSignInDateTime")
    @Expose
    public java.util.Calendar approximateLastSignInDateTime;

    /**
     * The Device Id.
	 * 
     */
    @SerializedName("deviceId")
    @Expose
    public String deviceId;

    /**
     * The Device Metadata.
	 * 
     */
    @SerializedName("deviceMetadata")
    @Expose
    public String deviceMetadata;

    /**
     * The Device Version.
	 * 
     */
    @SerializedName("deviceVersion")
    @Expose
    public Integer deviceVersion;

    /**
     * The Display Name.
	 * 
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Is Compliant.
	 * 
     */
    @SerializedName("isCompliant")
    @Expose
    public Boolean isCompliant;

    /**
     * The Is Managed.
	 * 
     */
    @SerializedName("isManaged")
    @Expose
    public Boolean isManaged;

    /**
     * The On Premises Last Sync Date Time.
	 * 
     */
    @SerializedName("onPremisesLastSyncDateTime")
    @Expose
    public java.util.Calendar onPremisesLastSyncDateTime;

    /**
     * The On Premises Sync Enabled.
	 * 
     */
    @SerializedName("onPremisesSyncEnabled")
    @Expose
    public Boolean onPremisesSyncEnabled;

    /**
     * The Operating System.
	 * 
     */
    @SerializedName("operatingSystem")
    @Expose
    public String operatingSystem;

    /**
     * The Operating System Version.
	 * 
     */
    @SerializedName("operatingSystemVersion")
    @Expose
    public String operatingSystemVersion;

    /**
     * The Physical Ids.
	 * 
     */
    @SerializedName("physicalIds")
    @Expose
    public java.util.List<String> physicalIds;

    /**
     * The Trust Type.
	 * 
     */
    @SerializedName("trustType")
    @Expose
    public String trustType;

    /**
     * The Registered Owners.
	 * 
     */
    public transient DirectoryObjectCollectionPage registeredOwners;

    /**
     * The Registered Users.
	 * 
     */
    public transient DirectoryObjectCollectionPage registeredUsers;


    /**
     * The raw representation of this class
     */
    private transient JsonObject mRawObject;

    /**
     * The serializer
     */
    private transient ISerializer mSerializer;

    /**
     * Gets the raw representation of this class
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return mRawObject;
    }

    /**
     * Gets serializer
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return mSerializer;
    }

    /**
     * Sets the raw json object
     *
     * @param serializer The serializer
     * @param json The json object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        mSerializer = serializer;
        mRawObject = json;


        if (json.has("registeredOwners")) {
            final BaseDirectoryObjectCollectionResponse response = new BaseDirectoryObjectCollectionResponse();
            if (json.has("registeredOwners@odata.nextLink")) {
                response.nextLink = json.get("registeredOwners@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("registeredOwners").toString(), JsonObject[].class);
            final DirectoryObject[] array = new DirectoryObject[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DirectoryObject.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            registeredOwners = new DirectoryObjectCollectionPage(response, null);
        }

        if (json.has("registeredUsers")) {
            final BaseDirectoryObjectCollectionResponse response = new BaseDirectoryObjectCollectionResponse();
            if (json.has("registeredUsers@odata.nextLink")) {
                response.nextLink = json.get("registeredUsers@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("registeredUsers").toString(), JsonObject[].class);
            final DirectoryObject[] array = new DirectoryObject[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DirectoryObject.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            registeredUsers = new DirectoryObjectCollectionPage(response, null);
        }
    }
}
