/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Event;
import com.microsoft.graph.extensions.EventCollectionPage;
import com.microsoft.graph.extensions.EventCollectionRequest;
import com.microsoft.graph.extensions.EventCollectionRequestBuilder;
import com.microsoft.graph.extensions.EventRequestBuilder;
import com.microsoft.graph.extensions.IEventCollectionPage;
import com.microsoft.graph.extensions.IEventCollectionRequest;
import com.microsoft.graph.generated.BaseEventCollectionResponse;
import com.microsoft.graph.generated.IBaseEventCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseEventCollectionRequest
extends BaseCollectionRequest<BaseEventCollectionResponse, IEventCollectionPage>
implements IBaseEventCollectionRequest {
    public BaseEventCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseEventCollectionResponse.class, IEventCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEventCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseEventCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEventCollectionPage get() throws ClientException {
        BaseEventCollectionResponse response = (BaseEventCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Event newEvent, ICallback<Event> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newEvent, callback);
    }

    @Override
    public Event post(Event newEvent) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EventRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newEvent);
    }

    @Override
    public IEventCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (EventCollectionRequest)this;
    }

    @Override
    public IEventCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (EventCollectionRequest)this;
    }

    @Override
    public IEventCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (EventCollectionRequest)this;
    }

    public IEventCollectionPage buildFromResponse(BaseEventCollectionResponse response) {
        EventCollectionRequestBuilder builder = response.nextLink != null ? new EventCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EventCollectionPage page = new EventCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

