/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Contract;
import com.microsoft.graph.extensions.ContractCollectionPage;
import com.microsoft.graph.extensions.ContractCollectionRequest;
import com.microsoft.graph.extensions.ContractCollectionRequestBuilder;
import com.microsoft.graph.extensions.ContractRequestBuilder;
import com.microsoft.graph.extensions.IContractCollectionPage;
import com.microsoft.graph.extensions.IContractCollectionRequest;
import com.microsoft.graph.generated.BaseContractCollectionResponse;
import com.microsoft.graph.generated.IBaseContractCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseContractCollectionRequest
extends BaseCollectionRequest<BaseContractCollectionResponse, IContractCollectionPage>
implements IBaseContractCollectionRequest {
    public BaseContractCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseContractCollectionResponse.class, IContractCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContractCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseContractCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContractCollectionPage get() throws ClientException {
        BaseContractCollectionResponse response = (BaseContractCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Contract newContract, ICallback<Contract> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContractRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newContract, callback);
    }

    @Override
    public Contract post(Contract newContract) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContractRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newContract);
    }

    @Override
    public IContractCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ContractCollectionRequest)this;
    }

    @Override
    public IContractCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ContractCollectionRequest)this;
    }

    @Override
    public IContractCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ContractCollectionRequest)this;
    }

    public IContractCollectionPage buildFromResponse(BaseContractCollectionResponse response) {
        ContractCollectionRequestBuilder builder = response.nextLink != null ? new ContractCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContractCollectionPage page = new ContractCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

