/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.Calendar;
import com.microsoft.graph.extensions.CalendarCollectionPage;
import com.microsoft.graph.extensions.CalendarCollectionRequest;
import com.microsoft.graph.extensions.CalendarCollectionRequestBuilder;
import com.microsoft.graph.extensions.CalendarRequestBuilder;
import com.microsoft.graph.extensions.ICalendarCollectionPage;
import com.microsoft.graph.extensions.ICalendarCollectionRequest;
import com.microsoft.graph.generated.BaseCalendarCollectionResponse;
import com.microsoft.graph.generated.IBaseCalendarCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseCalendarCollectionRequest
extends BaseCollectionRequest<BaseCalendarCollectionResponse, ICalendarCollectionPage>
implements IBaseCalendarCollectionRequest {
    public BaseCalendarCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseCalendarCollectionResponse.class, ICalendarCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ICalendarCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseCalendarCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICalendarCollectionPage get() throws ClientException {
        BaseCalendarCollectionResponse response = (BaseCalendarCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Calendar newCalendar, ICallback<Calendar> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newCalendar, callback);
    }

    @Override
    public Calendar post(Calendar newCalendar) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CalendarRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newCalendar);
    }

    @Override
    public ICalendarCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (CalendarCollectionRequest)this;
    }

    @Override
    public ICalendarCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (CalendarCollectionRequest)this;
    }

    @Override
    public ICalendarCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (CalendarCollectionRequest)this;
    }

    public ICalendarCollectionPage buildFromResponse(BaseCalendarCollectionResponse response) {
        CalendarCollectionRequestBuilder builder = response.nextLink != null ? new CalendarCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CalendarCollectionPage page = new CalendarCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

