// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Request.
 */
public interface IBaseWorkbookChartRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChart from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChart> callback);

    /**
     * Gets the WorkbookChart from the service
     * @return The WorkbookChart from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChart get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChart with a source
     * @param sourceWorkbookChart The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChart sourceWorkbookChart, final ICallback<WorkbookChart> callback);

    /**
     * Patches this WorkbookChart with a source
     * @param sourceWorkbookChart The source object with updates
     * @return The updated WorkbookChart
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChart patch(final WorkbookChart sourceWorkbookChart) throws ClientException;

    /**
     * Posts a WorkbookChart with a new object
     * @param newWorkbookChart The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChart newWorkbookChart, final ICallback<WorkbookChart> callback);

    /**
     * Posts a WorkbookChart with a new object
     * @param newWorkbookChart The new object to create
     * @return The created WorkbookChart
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChart post(final WorkbookChart newWorkbookChart) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartRequest expand(final String value);

}
