// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Axis Title Format Request.
 */
public interface IBaseWorkbookChartAxisTitleFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxisTitleFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Gets the WorkbookChartAxisTitleFormat from the service
     * @return The WorkbookChartAxisTitleFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitleFormat get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxisTitleFormat with a source
     * @param sourceWorkbookChartAxisTitleFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartAxisTitleFormat sourceWorkbookChartAxisTitleFormat, final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Patches this WorkbookChartAxisTitleFormat with a source
     * @param sourceWorkbookChartAxisTitleFormat The source object with updates
     * @return The updated WorkbookChartAxisTitleFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitleFormat patch(final WorkbookChartAxisTitleFormat sourceWorkbookChartAxisTitleFormat) throws ClientException;

    /**
     * Posts a WorkbookChartAxisTitleFormat with a new object
     * @param newWorkbookChartAxisTitleFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartAxisTitleFormat newWorkbookChartAxisTitleFormat, final ICallback<WorkbookChartAxisTitleFormat> callback);

    /**
     * Posts a WorkbookChartAxisTitleFormat with a new object
     * @param newWorkbookChartAxisTitleFormat The new object to create
     * @return The created WorkbookChartAxisTitleFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartAxisTitleFormat post(final WorkbookChartAxisTitleFormat newWorkbookChartAxisTitleFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartAxisTitleFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartAxisTitleFormatRequest expand(final String value);

}
