// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Single Value Legacy Extended Property Request.
 */
public interface IBaseSingleValueLegacyExtendedPropertyRequest extends IHttpRequest {

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<SingleValueLegacyExtendedProperty> callback);

    /**
     * Gets the SingleValueLegacyExtendedProperty from the service
     * @return The SingleValueLegacyExtendedProperty from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SingleValueLegacyExtendedProperty get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     * @param sourceSingleValueLegacyExtendedProperty The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty, final ICallback<SingleValueLegacyExtendedProperty> callback);

    /**
     * Patches this SingleValueLegacyExtendedProperty with a source
     * @param sourceSingleValueLegacyExtendedProperty The source object with updates
     * @return The updated SingleValueLegacyExtendedProperty
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SingleValueLegacyExtendedProperty patch(final SingleValueLegacyExtendedProperty sourceSingleValueLegacyExtendedProperty) throws ClientException;

    /**
     * Posts a SingleValueLegacyExtendedProperty with a new object
     * @param newSingleValueLegacyExtendedProperty The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty, final ICallback<SingleValueLegacyExtendedProperty> callback);

    /**
     * Posts a SingleValueLegacyExtendedProperty with a new object
     * @param newSingleValueLegacyExtendedProperty The new object to create
     * @return The created SingleValueLegacyExtendedProperty
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    SingleValueLegacyExtendedProperty post(final SingleValueLegacyExtendedProperty newSingleValueLegacyExtendedProperty) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseSingleValueLegacyExtendedPropertyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseSingleValueLegacyExtendedPropertyRequest expand(final String value);

}
