// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Domain Dns Srv Record Request.
 */
public interface IBaseDomainDnsSrvRecordRequest extends IHttpRequest {

    /**
     * Gets the DomainDnsSrvRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<DomainDnsSrvRecord> callback);

    /**
     * Gets the DomainDnsSrvRecord from the service
     * @return The DomainDnsSrvRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsSrvRecord get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DomainDnsSrvRecord with a source
     * @param sourceDomainDnsSrvRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final DomainDnsSrvRecord sourceDomainDnsSrvRecord, final ICallback<DomainDnsSrvRecord> callback);

    /**
     * Patches this DomainDnsSrvRecord with a source
     * @param sourceDomainDnsSrvRecord The source object with updates
     * @return The updated DomainDnsSrvRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsSrvRecord patch(final DomainDnsSrvRecord sourceDomainDnsSrvRecord) throws ClientException;

    /**
     * Posts a DomainDnsSrvRecord with a new object
     * @param newDomainDnsSrvRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final DomainDnsSrvRecord newDomainDnsSrvRecord, final ICallback<DomainDnsSrvRecord> callback);

    /**
     * Posts a DomainDnsSrvRecord with a new object
     * @param newDomainDnsSrvRecord The new object to create
     * @return The created DomainDnsSrvRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    DomainDnsSrvRecord post(final DomainDnsSrvRecord newDomainDnsSrvRecord) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseDomainDnsSrvRecordRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseDomainDnsSrvRecordRequest expand(final String value);

}
