// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Worksheet Request.
 */
public class BaseWorkbookWorksheetRequest extends BaseRequest implements IBaseWorkbookWorksheetRequest {

    /**
     * The request for the WorkbookWorksheet
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookWorksheetRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookWorksheet from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookWorksheet> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookWorksheet from the service
     * @return The WorkbookWorksheet from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookWorksheet with a source
     * @param sourceWorkbookWorksheet The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookWorksheet sourceWorkbookWorksheet, final ICallback<WorkbookWorksheet> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookWorksheet);
    }

    /**
     * Patches this WorkbookWorksheet with a source
     * @param sourceWorkbookWorksheet The source object with updates
     * @return The updated WorkbookWorksheet
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheet patch(final WorkbookWorksheet sourceWorkbookWorksheet) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     * @param newWorkbookWorksheet The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookWorksheet newWorkbookWorksheet, final ICallback<WorkbookWorksheet> callback) {
        send(HttpMethod.POST, callback, newWorkbookWorksheet);
    }

    /**
     * Creates a WorkbookWorksheet with a new object
     * @param newWorkbookWorksheet The new object to create
     * @return The created WorkbookWorksheet
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheet post(final WorkbookWorksheet newWorkbookWorksheet) throws ClientException {
        return send(HttpMethod.POST, newWorkbookWorksheet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookWorksheetRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookWorksheetRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookWorksheetRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookWorksheetRequest)this;
     }

}
