// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Worksheet Protection Request.
 */
public class BaseWorkbookWorksheetProtectionRequest extends BaseRequest implements IBaseWorkbookWorksheetProtectionRequest {

    /**
     * The request for the WorkbookWorksheetProtection
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookWorksheetProtectionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookWorksheetProtection from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookWorksheetProtection> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookWorksheetProtection from the service
     * @return The WorkbookWorksheetProtection from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheetProtection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookWorksheetProtection with a source
     * @param sourceWorkbookWorksheetProtection The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookWorksheetProtection sourceWorkbookWorksheetProtection, final ICallback<WorkbookWorksheetProtection> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookWorksheetProtection);
    }

    /**
     * Patches this WorkbookWorksheetProtection with a source
     * @param sourceWorkbookWorksheetProtection The source object with updates
     * @return The updated WorkbookWorksheetProtection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheetProtection patch(final WorkbookWorksheetProtection sourceWorkbookWorksheetProtection) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookWorksheetProtection);
    }

    /**
     * Creates a WorkbookWorksheetProtection with a new object
     * @param newWorkbookWorksheetProtection The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookWorksheetProtection newWorkbookWorksheetProtection, final ICallback<WorkbookWorksheetProtection> callback) {
        send(HttpMethod.POST, callback, newWorkbookWorksheetProtection);
    }

    /**
     * Creates a WorkbookWorksheetProtection with a new object
     * @param newWorkbookWorksheetProtection The new object to create
     * @return The created WorkbookWorksheetProtection
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookWorksheetProtection post(final WorkbookWorksheetProtection newWorkbookWorksheetProtection) throws ClientException {
        return send(HttpMethod.POST, newWorkbookWorksheetProtection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookWorksheetProtectionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookWorksheetProtectionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookWorksheetProtectionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookWorksheetProtectionRequest)this;
     }

}
