// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Request Builder.
 */
public class BaseWorkbookRangeRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookRangeRequestBuilder {

    /**
     * The request builder for the WorkbookRange
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookRangeRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     */
    public IWorkbookRangeRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     */
    public IWorkbookRangeRequest buildRequest(final java.util.List<Option> requestOptions) {
        return new WorkbookRangeRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     * Gets the request builder for WorkbookRangeFormat.
     */
    public IWorkbookRangeFormatRequestBuilder getFormat() {
        return new WorkbookRangeFormatRequestBuilder(getRequestUrlWithAdditionalSegment("format"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookRangeSort.
     */
    public IWorkbookRangeSortRequestBuilder getSort() {
        return new WorkbookRangeSortRequestBuilder(getRequestUrlWithAdditionalSegment("sort"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookWorksheet.
     */
    public IWorkbookWorksheetRequestBuilder getWorksheet() {
        return new WorkbookWorksheetRequestBuilder(getRequestUrlWithAdditionalSegment("worksheet"), getClient(), null);
    }

    public IWorkbookRangeClearRequestBuilder getClear(final String applyTo) {
        return new WorkbookRangeClearRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clear"), getClient(), null, applyTo);
    }

    public IWorkbookRangeDeleteRequestBuilder getDelete(final String shift) {
        return new WorkbookRangeDeleteRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.delete"), getClient(), null, shift);
    }

    public IWorkbookRangeInsertRequestBuilder getInsert(final String shift) {
        return new WorkbookRangeInsertRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.insert"), getClient(), null, shift);
    }

    public IWorkbookRangeMergeRequestBuilder getMerge(final Boolean across) {
        return new WorkbookRangeMergeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.merge"), getClient(), null, across);
    }

    public IWorkbookRangeUnmergeRequestBuilder getUnmerge() {
        return new WorkbookRangeUnmergeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.unmerge"), getClient(), null);
    }

    public IWorkbookRangeBoundingRectRequestBuilder getBoundingRect(final String anotherRange) {
        return new WorkbookRangeBoundingRectRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.boundingRect"), getClient(), null, anotherRange);
    }

    public IWorkbookRangeCellRequestBuilder getCell(final Integer row, final Integer column) {
        return new WorkbookRangeCellRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.cell"), getClient(), null, row, column);
    }

    public IWorkbookRangeColumnRequestBuilder getColumn(final Integer column) {
        return new WorkbookRangeColumnRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.column"), getClient(), null, column);
    }

    public IWorkbookRangeColumnsAfterRequestBuilder getColumnsAfter() {
        return new WorkbookRangeColumnsAfterRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.columnsAfter"), getClient(), null);
    }

    public IWorkbookRangeColumnsAfterRequestBuilder getColumnsAfter(final Integer count) {
        return new WorkbookRangeColumnsAfterRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.columnsAfter"), getClient(), null, count);
    }

    public IWorkbookRangeColumnsBeforeRequestBuilder getColumnsBefore() {
        return new WorkbookRangeColumnsBeforeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.columnsBefore"), getClient(), null);
    }

    public IWorkbookRangeColumnsBeforeRequestBuilder getColumnsBefore(final Integer count) {
        return new WorkbookRangeColumnsBeforeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.columnsBefore"), getClient(), null, count);
    }

    public IWorkbookRangeEntireColumnRequestBuilder getEntireColumn() {
        return new WorkbookRangeEntireColumnRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.entireColumn"), getClient(), null);
    }

    public IWorkbookRangeEntireRowRequestBuilder getEntireRow() {
        return new WorkbookRangeEntireRowRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.entireRow"), getClient(), null);
    }

    public IWorkbookRangeIntersectionRequestBuilder getIntersection(final String anotherRange) {
        return new WorkbookRangeIntersectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.intersection"), getClient(), null, anotherRange);
    }

    public IWorkbookRangeLastCellRequestBuilder getLastCell() {
        return new WorkbookRangeLastCellRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.lastCell"), getClient(), null);
    }

    public IWorkbookRangeLastColumnRequestBuilder getLastColumn() {
        return new WorkbookRangeLastColumnRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.lastColumn"), getClient(), null);
    }

    public IWorkbookRangeLastRowRequestBuilder getLastRow() {
        return new WorkbookRangeLastRowRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.lastRow"), getClient(), null);
    }

    public IWorkbookRangeOffsetRangeRequestBuilder getOffsetRange(final Integer rowOffset, final Integer columnOffset) {
        return new WorkbookRangeOffsetRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.offsetRange"), getClient(), null, rowOffset, columnOffset);
    }

    public IWorkbookRangeResizedRangeRequestBuilder getResizedRange(final Integer deltaRows, final Integer deltaColumns) {
        return new WorkbookRangeResizedRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.resizedRange"), getClient(), null, deltaRows, deltaColumns);
    }

    public IWorkbookRangeRowRequestBuilder getRow(final Integer row) {
        return new WorkbookRangeRowRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.row"), getClient(), null, row);
    }

    public IWorkbookRangeRowsAboveRequestBuilder getRowsAbove() {
        return new WorkbookRangeRowsAboveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.rowsAbove"), getClient(), null);
    }

    public IWorkbookRangeRowsAboveRequestBuilder getRowsAbove(final Integer count) {
        return new WorkbookRangeRowsAboveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.rowsAbove"), getClient(), null, count);
    }

    public IWorkbookRangeRowsBelowRequestBuilder getRowsBelow() {
        return new WorkbookRangeRowsBelowRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.rowsBelow"), getClient(), null);
    }

    public IWorkbookRangeRowsBelowRequestBuilder getRowsBelow(final Integer count) {
        return new WorkbookRangeRowsBelowRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.rowsBelow"), getClient(), null, count);
    }

    public IWorkbookRangeUsedRangeRequestBuilder getUsedRange() {
        return new WorkbookRangeUsedRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.usedRange"), getClient(), null);
    }

    public IWorkbookRangeUsedRangeRequestBuilder getUsedRange(final Boolean valuesOnly) {
        return new WorkbookRangeUsedRangeRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.usedRange"), getClient(), null, valuesOnly);
    }

    public IWorkbookRangeVisibleViewRequestBuilder getVisibleView() {
        return new WorkbookRangeVisibleViewRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.visibleView"), getClient(), null);
    }
}
