// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Font Request.
 */
public class BaseWorkbookRangeFontRequest extends BaseRequest implements IBaseWorkbookRangeFontRequest {

    /**
     * The request for the WorkbookRangeFont
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookRangeFontRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookRangeFont from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookRangeFont> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRangeFont from the service
     * @return The WorkbookRangeFont from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeFont get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookRangeFont with a source
     * @param sourceWorkbookRangeFont The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookRangeFont sourceWorkbookRangeFont, final ICallback<WorkbookRangeFont> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookRangeFont);
    }

    /**
     * Patches this WorkbookRangeFont with a source
     * @param sourceWorkbookRangeFont The source object with updates
     * @return The updated WorkbookRangeFont
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeFont patch(final WorkbookRangeFont sourceWorkbookRangeFont) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     * @param newWorkbookRangeFont The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookRangeFont newWorkbookRangeFont, final ICallback<WorkbookRangeFont> callback) {
        send(HttpMethod.POST, callback, newWorkbookRangeFont);
    }

    /**
     * Creates a WorkbookRangeFont with a new object
     * @param newWorkbookRangeFont The new object to create
     * @return The created WorkbookRangeFont
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookRangeFont post(final WorkbookRangeFont newWorkbookRangeFont) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeFont);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookRangeFontRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookRangeFontRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookRangeFontRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookRangeFontRequest)this;
     }

}
