// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Named Item Add Formula Local Request Builder.
 */
public class BaseWorkbookNamedItemAddFormulaLocalRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookNamedItemAddFormulaLocal
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookNamedItemAddFormulaLocalRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<Option> requestOptions, final String name, final String formula, final String comment) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("name", name);
        mBodyParams.put("formula", formula);
        mBodyParams.put("comment", comment);
    }

    /**
     * Creates the IWorkbookNamedItemAddFormulaLocalRequest
     *
     * @return The IWorkbookNamedItemAddFormulaLocalRequest instance
     */
    public IWorkbookNamedItemAddFormulaLocalRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookNamedItemAddFormulaLocalRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookNamedItemAddFormulaLocalRequest instance
     */
    public IWorkbookNamedItemAddFormulaLocalRequest buildRequest(final java.util.List<Option> requestOptions) {
        WorkbookNamedItemAddFormulaLocalRequest request = new WorkbookNamedItemAddFormulaLocalRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("name")) {
            request.mBody.name = getParameter("name");
        }

        if (hasParameter("formula")) {
            request.mBody.formula = getParameter("formula");
        }

        if (hasParameter("comment")) {
            request.mBody.comment = getParameter("comment");
        }

        return request;
    }
}
