// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Data Label Format Request.
 */
public class BaseWorkbookChartDataLabelFormatRequest extends BaseRequest implements IBaseWorkbookChartDataLabelFormatRequest {

    /**
     * The request for the WorkbookChartDataLabelFormat
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartDataLabelFormatRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartDataLabelFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartDataLabelFormat> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartDataLabelFormat from the service
     * @return The WorkbookChartDataLabelFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartDataLabelFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartDataLabelFormat with a source
     * @param sourceWorkbookChartDataLabelFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartDataLabelFormat sourceWorkbookChartDataLabelFormat, final ICallback<WorkbookChartDataLabelFormat> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartDataLabelFormat);
    }

    /**
     * Patches this WorkbookChartDataLabelFormat with a source
     * @param sourceWorkbookChartDataLabelFormat The source object with updates
     * @return The updated WorkbookChartDataLabelFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartDataLabelFormat patch(final WorkbookChartDataLabelFormat sourceWorkbookChartDataLabelFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartDataLabelFormat);
    }

    /**
     * Creates a WorkbookChartDataLabelFormat with a new object
     * @param newWorkbookChartDataLabelFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat, final ICallback<WorkbookChartDataLabelFormat> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartDataLabelFormat);
    }

    /**
     * Creates a WorkbookChartDataLabelFormat with a new object
     * @param newWorkbookChartDataLabelFormat The new object to create
     * @return The created WorkbookChartDataLabelFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartDataLabelFormat post(final WorkbookChartDataLabelFormat newWorkbookChartDataLabelFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartDataLabelFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartDataLabelFormatRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartDataLabelFormatRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartDataLabelFormatRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartDataLabelFormatRequest)this;
     }

}
