// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

// **NOTE** This file was generated by a tool and any changes will be overwritten.
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Multi Value Legacy Extended Property Collection Request.
 */
public class BaseMultiValueLegacyExtendedPropertyCollectionRequest extends BaseCollectionRequest<BaseMultiValueLegacyExtendedPropertyCollectionResponse, IMultiValueLegacyExtendedPropertyCollectionPage> implements IBaseMultiValueLegacyExtendedPropertyCollectionRequest {

    /**
     * The request builder for this collection of MultiValueLegacyExtendedProperty
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseMultiValueLegacyExtendedPropertyCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseMultiValueLegacyExtendedPropertyCollectionResponse.class, IMultiValueLegacyExtendedPropertyCollectionPage.class);
    }

    public void get(final ICallback<IMultiValueLegacyExtendedPropertyCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IMultiValueLegacyExtendedPropertyCollectionPage get() throws ClientException {
        final BaseMultiValueLegacyExtendedPropertyCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty, final ICallback<MultiValueLegacyExtendedProperty> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new MultiValueLegacyExtendedPropertyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newMultiValueLegacyExtendedProperty, callback);
    }

    public MultiValueLegacyExtendedProperty post(final MultiValueLegacyExtendedProperty newMultiValueLegacyExtendedProperty) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new MultiValueLegacyExtendedPropertyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest()
            .post(newMultiValueLegacyExtendedProperty);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    public IMultiValueLegacyExtendedPropertyCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    public IMultiValueLegacyExtendedPropertyCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value The max number of items to return
     * @return The updated request
     */
    public IMultiValueLegacyExtendedPropertyCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (MultiValueLegacyExtendedPropertyCollectionRequest)this;
    }

    public IMultiValueLegacyExtendedPropertyCollectionPage buildFromResponse(final BaseMultiValueLegacyExtendedPropertyCollectionResponse response) {
        final IMultiValueLegacyExtendedPropertyCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new MultiValueLegacyExtendedPropertyCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final MultiValueLegacyExtendedPropertyCollectionPage page = new MultiValueLegacyExtendedPropertyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
