// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Request.
 */
public class BaseDomainRequest extends BaseRequest implements IBaseDomainRequest {

    /**
     * The request for the Domain
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDomainRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the Domain from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<Domain> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Domain from the service
     * @return The Domain from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Domain get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this Domain with a source
     * @param sourceDomain The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final Domain sourceDomain, final ICallback<Domain> callback) {
        send(HttpMethod.PATCH, callback, sourceDomain);
    }

    /**
     * Patches this Domain with a source
     * @param sourceDomain The source object with updates
     * @return The updated Domain
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Domain patch(final Domain sourceDomain) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomain);
    }

    /**
     * Creates a Domain with a new object
     * @param newDomain The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final Domain newDomain, final ICallback<Domain> callback) {
        send(HttpMethod.POST, callback, newDomain);
    }

    /**
     * Creates a Domain with a new object
     * @param newDomain The new object to create
     * @return The created Domain
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public Domain post(final Domain newDomain) throws ClientException {
        return send(HttpMethod.POST, newDomain);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDomainRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DomainRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDomainRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DomainRequest)this;
     }

}
