// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Domain Dns Txt Record Request.
 */
public class BaseDomainDnsTxtRecordRequest extends BaseRequest implements IBaseDomainDnsTxtRecordRequest {

    /**
     * The request for the DomainDnsTxtRecord
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseDomainDnsTxtRecordRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the DomainDnsTxtRecord from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<DomainDnsTxtRecord> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DomainDnsTxtRecord from the service
     * @return The DomainDnsTxtRecord from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsTxtRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this DomainDnsTxtRecord with a source
     * @param sourceDomainDnsTxtRecord The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final DomainDnsTxtRecord sourceDomainDnsTxtRecord, final ICallback<DomainDnsTxtRecord> callback) {
        send(HttpMethod.PATCH, callback, sourceDomainDnsTxtRecord);
    }

    /**
     * Patches this DomainDnsTxtRecord with a source
     * @param sourceDomainDnsTxtRecord The source object with updates
     * @return The updated DomainDnsTxtRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsTxtRecord patch(final DomainDnsTxtRecord sourceDomainDnsTxtRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsTxtRecord);
    }

    /**
     * Creates a DomainDnsTxtRecord with a new object
     * @param newDomainDnsTxtRecord The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final DomainDnsTxtRecord newDomainDnsTxtRecord, final ICallback<DomainDnsTxtRecord> callback) {
        send(HttpMethod.POST, callback, newDomainDnsTxtRecord);
    }

    /**
     * Creates a DomainDnsTxtRecord with a new object
     * @param newDomainDnsTxtRecord The new object to create
     * @return The created DomainDnsTxtRecord
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public DomainDnsTxtRecord post(final DomainDnsTxtRecord newDomainDnsTxtRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsTxtRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IDomainDnsTxtRecordRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (DomainDnsTxtRecordRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IDomainDnsTxtRecordRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (DomainDnsTxtRecordRequest)this;
     }

}
