/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IWorkbookRangeViewCollectionPage;
import com.microsoft.graph.extensions.IWorkbookRangeViewCollectionRequest;
import com.microsoft.graph.extensions.WorkbookRangeView;
import com.microsoft.graph.extensions.WorkbookRangeViewCollectionPage;
import com.microsoft.graph.extensions.WorkbookRangeViewCollectionRequest;
import com.microsoft.graph.extensions.WorkbookRangeViewCollectionRequestBuilder;
import com.microsoft.graph.extensions.WorkbookRangeViewRequestBuilder;
import com.microsoft.graph.generated.BaseWorkbookRangeViewCollectionResponse;
import com.microsoft.graph.generated.IBaseWorkbookRangeViewCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseWorkbookRangeViewCollectionRequest
extends BaseCollectionRequest<BaseWorkbookRangeViewCollectionResponse, IWorkbookRangeViewCollectionPage>
implements IBaseWorkbookRangeViewCollectionRequest {
    public BaseWorkbookRangeViewCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseWorkbookRangeViewCollectionResponse.class, IWorkbookRangeViewCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWorkbookRangeViewCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseWorkbookRangeViewCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWorkbookRangeViewCollectionPage get() throws ClientException {
        BaseWorkbookRangeViewCollectionResponse response = (BaseWorkbookRangeViewCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WorkbookRangeView newWorkbookRangeView, ICallback<WorkbookRangeView> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WorkbookRangeViewRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookRangeView, callback);
    }

    @Override
    public WorkbookRangeView post(WorkbookRangeView newWorkbookRangeView) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkbookRangeViewRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newWorkbookRangeView);
    }

    @Override
    public IWorkbookRangeViewCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (WorkbookRangeViewCollectionRequest)this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (WorkbookRangeViewCollectionRequest)this;
    }

    @Override
    public IWorkbookRangeViewCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (WorkbookRangeViewCollectionRequest)this;
    }

    public IWorkbookRangeViewCollectionPage buildFromResponse(BaseWorkbookRangeViewCollectionResponse response) {
        WorkbookRangeViewCollectionRequestBuilder builder = response.nextLink != null ? new WorkbookRangeViewCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WorkbookRangeViewCollectionPage page = new WorkbookRangeViewCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

