// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Functions Request.
 */
public interface IBaseWorkbookFunctionsRequest extends IHttpRequest {

    /**
     * Gets the WorkbookFunctions from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookFunctions> callback);

    /**
     * Gets the WorkbookFunctions from the service
     * @return The WorkbookFunctions from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFunctions get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookFunctions with a source
     * @param sourceWorkbookFunctions The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookFunctions sourceWorkbookFunctions, final ICallback<WorkbookFunctions> callback);

    /**
     * Patches this WorkbookFunctions with a source
     * @param sourceWorkbookFunctions The source object with updates
     * @return The updated WorkbookFunctions
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFunctions patch(final WorkbookFunctions sourceWorkbookFunctions) throws ClientException;

    /**
     * Posts a WorkbookFunctions with a new object
     * @param newWorkbookFunctions The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookFunctions newWorkbookFunctions, final ICallback<WorkbookFunctions> callback);

    /**
     * Posts a WorkbookFunctions with a new object
     * @param newWorkbookFunctions The new object to create
     * @return The created WorkbookFunctions
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookFunctions post(final WorkbookFunctions newWorkbookFunctions) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookFunctionsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookFunctionsRequest expand(final String value);

}
