// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Filter Apply Custom Filter Request Builder.
 */
public class BaseWorkbookFilterApplyCustomFilterRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFilterApplyCustomFilter
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFilterApplyCustomFilterRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final String criteria1, final String criteria2, final String oper) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("criteria1", criteria1);
        mBodyParams.put("criteria2", criteria2);
        mBodyParams.put("oper", oper);
    }

    /**
     * Creates the IWorkbookFilterApplyCustomFilterRequest
     *
     * @return The IWorkbookFilterApplyCustomFilterRequest instance
     */
    public IWorkbookFilterApplyCustomFilterRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFilterApplyCustomFilterRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFilterApplyCustomFilterRequest instance
     */
    public IWorkbookFilterApplyCustomFilterRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFilterApplyCustomFilterRequest request = new WorkbookFilterApplyCustomFilterRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("criteria1")) {
            request.mBody.criteria1 = getParameter("criteria1");
        }

        if (hasParameter("criteria2")) {
            request.mBody.criteria2 = getParameter("criteria2");
        }

        if (hasParameter("oper")) {
            request.mBody.oper = getParameter("oper");
        }

        return request;
    }
}
