// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Gridlines Format Request.
 */
public class BaseWorkbookChartGridlinesFormatRequest extends BaseRequest implements IBaseWorkbookChartGridlinesFormatRequest {

    /**
     * The request for the WorkbookChartGridlinesFormat
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartGridlinesFormatRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartGridlinesFormat> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartGridlinesFormat from the service
     * @return The WorkbookChartGridlinesFormat from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartGridlinesFormat get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     * @param sourceWorkbookChartGridlinesFormat The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartGridlinesFormat);
    }

    /**
     * Patches this WorkbookChartGridlinesFormat with a source
     * @param sourceWorkbookChartGridlinesFormat The source object with updates
     * @return The updated WorkbookChartGridlinesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartGridlinesFormat patch(final WorkbookChartGridlinesFormat sourceWorkbookChartGridlinesFormat) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartGridlinesFormat);
    }

    /**
     * Creates a WorkbookChartGridlinesFormat with a new object
     * @param newWorkbookChartGridlinesFormat The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat, final ICallback<WorkbookChartGridlinesFormat> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartGridlinesFormat);
    }

    /**
     * Creates a WorkbookChartGridlinesFormat with a new object
     * @param newWorkbookChartGridlinesFormat The new object to create
     * @return The created WorkbookChartGridlinesFormat
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartGridlinesFormat post(final WorkbookChartGridlinesFormat newWorkbookChartGridlinesFormat) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartGridlinesFormat);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartGridlinesFormatRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartGridlinesFormatRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartGridlinesFormatRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartGridlinesFormatRequest)this;
     }

}
