// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Chart Axis Title Request.
 */
public class BaseWorkbookChartAxisTitleRequest extends BaseRequest implements IBaseWorkbookChartAxisTitleRequest {

    /**
     * The request for the WorkbookChartAxisTitle
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     * @param responseClass The class of the reponse
     */
    public BaseWorkbookChartAxisTitleRequest(final String requestUrl,
            final IBaseClient client,
            final List<Option> requestOptions,
            final Class responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * Gets the WorkbookChartAxisTitle from the service
     * @param callback The callback to be called after success or failure.
     */
    public void get(final ICallback<WorkbookChartAxisTitle> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartAxisTitle from the service
     * @return The WorkbookChartAxisTitle from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxisTitle get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    public void delete(final ICallback<Void> callback) {{
        send(HttpMethod.DELETE, callback, null);
    }}

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {{
        send(HttpMethod.DELETE, null);
    }}

    /**
     * Patches this WorkbookChartAxisTitle with a source
     * @param sourceWorkbookChartAxisTitle The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    public void patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookChartAxisTitle);
    }

    /**
     * Patches this WorkbookChartAxisTitle with a source
     * @param sourceWorkbookChartAxisTitle The source object with updates
     * @return The updated WorkbookChartAxisTitle
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxisTitle patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookChartAxisTitle);
    }

    /**
     * Creates a WorkbookChartAxisTitle with a new object
     * @param newWorkbookChartAxisTitle The new object to create
     * @param callback The callback to be called after success or failure.
     */
    public void post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback) {
        send(HttpMethod.POST, callback, newWorkbookChartAxisTitle);
    }

    /**
     * Creates a WorkbookChartAxisTitle with a new object
     * @param newWorkbookChartAxisTitle The new object to create
     * @return The created WorkbookChartAxisTitle
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    public WorkbookChartAxisTitle post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle) throws ClientException {
        return send(HttpMethod.POST, newWorkbookChartAxisTitle);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
     public IWorkbookChartAxisTitleRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (WorkbookChartAxisTitleRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
     public IWorkbookChartAxisTitleRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (WorkbookChartAxisTitleRequest)this;
     }

}
