/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.ConversationThread;
import com.microsoft.graph.extensions.ConversationThreadCollectionPage;
import com.microsoft.graph.extensions.ConversationThreadCollectionRequest;
import com.microsoft.graph.extensions.ConversationThreadCollectionRequestBuilder;
import com.microsoft.graph.extensions.ConversationThreadRequestBuilder;
import com.microsoft.graph.extensions.IConversationThreadCollectionPage;
import com.microsoft.graph.extensions.IConversationThreadCollectionRequest;
import com.microsoft.graph.generated.BaseConversationThreadCollectionResponse;
import com.microsoft.graph.generated.IBaseConversationThreadCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseConversationThreadCollectionRequest
extends BaseCollectionRequest<BaseConversationThreadCollectionResponse, IConversationThreadCollectionPage>
implements IBaseConversationThreadCollectionRequest {
    public BaseConversationThreadCollectionRequest(String requestUrl, IBaseClient client, List<Option> requestOptions) {
        super(requestUrl, client, requestOptions, BaseConversationThreadCollectionResponse.class, IConversationThreadCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IConversationThreadCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseConversationThreadCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IConversationThreadCollectionPage get() throws ClientException {
        BaseConversationThreadCollectionResponse response = (BaseConversationThreadCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ConversationThread newConversationThread, ICallback<ConversationThread> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ConversationThreadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newConversationThread, callback);
    }

    @Override
    public ConversationThread post(ConversationThread newConversationThread) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationThreadRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newConversationThread);
    }

    @Override
    public IConversationThreadCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (ConversationThreadCollectionRequest)this;
    }

    @Override
    public IConversationThreadCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (ConversationThreadCollectionRequest)this;
    }

    @Override
    public IConversationThreadCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (ConversationThreadCollectionRequest)this;
    }

    public IConversationThreadCollectionPage buildFromResponse(BaseConversationThreadCollectionResponse response) {
        ConversationThreadCollectionRequestBuilder builder = response.nextLink != null ? new ConversationThreadCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ConversationThreadCollectionPage page = new ConversationThreadCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

