// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Workbook Chart Gridlines Request.
 */
public interface IBaseWorkbookChartGridlinesRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartGridlines from the service
     * @param callback The callback to be called after success or failure.
     */
    void get(final ICallback<WorkbookChartGridlines> callback);

    /**
     * Gets the WorkbookChartGridlines from the service
     * @return The WorkbookChartGridlines from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlines get() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartGridlines with a source
     * @param sourceWorkbookChartGridlines The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final WorkbookChartGridlines sourceWorkbookChartGridlines, final ICallback<WorkbookChartGridlines> callback);

    /**
     * Patches this WorkbookChartGridlines with a source
     * @param sourceWorkbookChartGridlines The source object with updates
     * @return The updated WorkbookChartGridlines
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlines patch(final WorkbookChartGridlines sourceWorkbookChartGridlines) throws ClientException;

    /**
     * Posts a WorkbookChartGridlines with a new object
     * @param newWorkbookChartGridlines The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final WorkbookChartGridlines newWorkbookChartGridlines, final ICallback<WorkbookChartGridlines> callback);

    /**
     * Posts a WorkbookChartGridlines with a new object
     * @param newWorkbookChartGridlines The new object to create
     * @return The created WorkbookChartGridlines
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    WorkbookChartGridlines post(final WorkbookChartGridlines newWorkbookChartGridlines) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseWorkbookChartGridlinesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseWorkbookChartGridlinesRequest expand(final String value);

}
