// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Base Outlook Item Request.
 */
public interface IBaseOutlookItemRequest extends IHttpRequest {

    /**
     * Gets the OutlookItem from the service
     * @param callback The callback to be called after success or failure.
     */
    void getOutlookItem(final ICallback<OutlookItem> callback);

    /**
     * Gets the OutlookItem from the service
     * @return The OutlookItem from the request.
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookItem getOutlookItem() throws ClientException;

    /**
     * Delete this item from the service.
     * @param callback The callback when the deletion action has completed
     */
    void delete(final ICallback<Void> callback);

    /**
     * Delete this item from the service.
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OutlookItem with a source
     * @param sourceOutlookItem The source object with updates
     * @param callback The callback to be called after success or failure.
     */
    void patch(final OutlookItem sourceOutlookItem, final ICallback<OutlookItem> callback);

    /**
     * Patches this OutlookItem with a source
     * @param sourceOutlookItem The source object with updates
     * @return The updated OutlookItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookItem patch(final OutlookItem sourceOutlookItem) throws ClientException;

    /**
     * Posts a OutlookItem with a new object
     * @param newOutlookItem The new object to create
     * @param callback The callback to be called after success or failure.
     */
    void post(final OutlookItem newOutlookItem, final ICallback<OutlookItem> callback);

    /**
     * Posts a OutlookItem with a new object
     * @param newOutlookItem The new object to create
     * @return The created OutlookItem
     * @throws ClientException This exception occurs if the request was unable to complete for any reason.
     */
    OutlookItem post(final OutlookItem newOutlookItem) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value The select clause
     * @return The updated request
     */
    IBaseOutlookItemRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value The expand clause
     * @return The updated request
     */
    IBaseOutlookItemRequest expand(final String value);

}
