// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Worksheet Collection Request Builder.
 */
public class BaseWorkbookWorksheetCollectionRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookWorksheetCollectionRequestBuilder {

    /**
     * The request builder for this collection of Workbook
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookWorksheetCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IWorkbookWorksheetCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IWorkbookWorksheetCollectionRequest buildRequest(final List<Option> requestOptions) {
        return new WorkbookWorksheetCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IWorkbookWorksheetRequestBuilder byId(final String id) {
        return new WorkbookWorksheetRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IWorkbookWorksheetAddRequestBuilder getAdd(final String name) {
        return new WorkbookWorksheetAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, name);
    }
}
