// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Table Column Collection Request Builder.
 */
public class BaseWorkbookTableColumnCollectionRequestBuilder extends BaseRequestBuilder implements IBaseWorkbookTableColumnCollectionRequestBuilder {

    /**
     * The request builder for this collection of WorkbookTable
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookTableColumnCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IWorkbookTableColumnCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IWorkbookTableColumnCollectionRequest buildRequest(final List<Option> requestOptions) {
        return new WorkbookTableColumnCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IWorkbookTableColumnRequestBuilder byId(final String id) {
        return new WorkbookTableColumnRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }

    public IWorkbookTableColumnAddRequestBuilder getAdd(final Integer index, final com.google.gson.JsonElement values) {
        return new WorkbookTableColumnAddRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.add"), getClient(), null, index, values);
    }

    public IWorkbookTableColumnItemAtRequestBuilder getItemAt(final Integer index) {
        return new WorkbookTableColumnItemAtRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.itemAt"), getClient(), null, index);
    }

    public IWorkbookTableColumnCountRequestBuilder getCount() {
        return new WorkbookTableColumnCountRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.count"), getClient(), null);
    }
}
