// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Range Insert Request Builder.
 */
public class BaseWorkbookRangeInsertRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookRangeInsert
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookRangeInsertRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final String shift) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("shift", shift);
    }

    /**
     * Creates the IWorkbookRangeInsertRequest
     *
     * @return The IWorkbookRangeInsertRequest instance
     */
    public IWorkbookRangeInsertRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookRangeInsertRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookRangeInsertRequest instance
     */
    public IWorkbookRangeInsertRequest buildRequest(final List<Option> requestOptions) {
        WorkbookRangeInsertRequest request = new WorkbookRangeInsertRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("shift")) {
            request.mBody.shift = getParameter("shift");
        }

        return request;
    }
}
