// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Substitute Request Builder.
 */
public class BaseWorkbookFunctionsSubstituteRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsSubstitute
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsSubstituteRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement text, final com.google.gson.JsonElement oldText, final com.google.gson.JsonElement newText, final com.google.gson.JsonElement instanceNum) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("text", text);
        mBodyParams.put("oldText", oldText);
        mBodyParams.put("newText", newText);
        mBodyParams.put("instanceNum", instanceNum);
    }

    /**
     * Creates the IWorkbookFunctionsSubstituteRequest
     *
     * @return The IWorkbookFunctionsSubstituteRequest instance
     */
    public IWorkbookFunctionsSubstituteRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsSubstituteRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsSubstituteRequest instance
     */
    public IWorkbookFunctionsSubstituteRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsSubstituteRequest request = new WorkbookFunctionsSubstituteRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("text")) {
            request.mBody.text = getParameter("text");
        }

        if (hasParameter("oldText")) {
            request.mBody.oldText = getParameter("oldText");
        }

        if (hasParameter("newText")) {
            request.mBody.newText = getParameter("newText");
        }

        if (hasParameter("instanceNum")) {
            request.mBody.instanceNum = getParameter("instanceNum");
        }

        return request;
    }
}
