// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Workbook Functions Mirr Request Builder.
 */
public class BaseWorkbookFunctionsMirrRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this WorkbookFunctionsMirr
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseWorkbookFunctionsMirrRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final com.google.gson.JsonElement values, final com.google.gson.JsonElement financeRate, final com.google.gson.JsonElement reinvestRate) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("values", values);
        mBodyParams.put("financeRate", financeRate);
        mBodyParams.put("reinvestRate", reinvestRate);
    }

    /**
     * Creates the IWorkbookFunctionsMirrRequest
     *
     * @return The IWorkbookFunctionsMirrRequest instance
     */
    public IWorkbookFunctionsMirrRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookFunctionsMirrRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IWorkbookFunctionsMirrRequest instance
     */
    public IWorkbookFunctionsMirrRequest buildRequest(final List<Option> requestOptions) {
        WorkbookFunctionsMirrRequest request = new WorkbookFunctionsMirrRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("values")) {
            request.mBody.values = getParameter("values");
        }

        if (hasParameter("financeRate")) {
            request.mBody.financeRate = getParameter("financeRate");
        }

        if (hasParameter("reinvestRate")) {
            request.mBody.reinvestRate = getParameter("reinvestRate");
        }

        return request;
    }
}
