// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Message Reply All Request Builder.
 */
public class BaseMessageReplyAllRequestBuilder extends BaseActionRequestBuilder {

    /**
     * The request builder for this MessageReplyAll
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseMessageReplyAllRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions, final String comment) {
        super(requestUrl, client, requestOptions);
        mBodyParams.put("comment", comment);
    }

    /**
     * Creates the IMessageReplyAllRequest
     *
     * @return The IMessageReplyAllRequest instance
     */
    public IMessageReplyAllRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IMessageReplyAllRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return The IMessageReplyAllRequest instance
     */
    public IMessageReplyAllRequest buildRequest(final List<Option> requestOptions) {
        MessageReplyAllRequest request = new MessageReplyAllRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("comment")) {
            request.mBody.comment = getParameter("comment");
        }

        return request;
    }
}
