// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.extensions.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.generated.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.List;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Base Drive Shared With Me Collection Request Builder.
 */
public class BaseDriveSharedWithMeCollectionRequestBuilder extends BaseFunctionRequestBuilder implements IBaseDriveSharedWithMeCollectionRequestBuilder {

    /**
     * The request builder for this collection of Drive
     *
     * @param requestUrl The request url
     * @param client The service client
     * @param requestOptions The options for this request
     */
    public BaseDriveSharedWithMeCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final List<Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public IDriveSharedWithMeCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IDriveSharedWithMeCollectionRequest buildRequest(final List<Option> requestOptions) {
        DriveSharedWithMeCollectionRequest request = new DriveSharedWithMeCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (FunctionOption option : mFunctionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
