/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.DriveItemSearchCollectionPage;
import com.microsoft.graph.extensions.DriveItemSearchCollectionRequestBuilder;
import com.microsoft.graph.extensions.IDriveItemSearchCollectionPage;
import com.microsoft.graph.extensions.IDriveItemSearchCollectionRequest;
import com.microsoft.graph.generated.BaseDriveItemSearchCollectionResponse;
import com.microsoft.graph.generated.IBaseDriveItemSearchCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseDriveItemSearchCollectionRequest
extends BaseCollectionRequest<BaseDriveItemSearchCollectionResponse, IDriveItemSearchCollectionPage>
implements IBaseDriveItemSearchCollectionRequest {
    public BaseDriveItemSearchCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseDriveItemSearchCollectionResponse.class, IDriveItemSearchCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemSearchCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseDriveItemSearchCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemSearchCollectionPage get() throws ClientException {
        BaseDriveItemSearchCollectionResponse response = (BaseDriveItemSearchCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveItemSearchCollectionPage buildFromResponse(BaseDriveItemSearchCollectionResponse response) {
        DriveItemSearchCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemSearchCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        DriveItemSearchCollectionPage page = new DriveItemSearchCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemSearchCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemSearchCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }

    @Override
    public IDriveItemSearchCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (IDriveItemSearchCollectionRequest)((Object)this);
    }
}

