/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.generated;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.extensions.IOrganizationCollectionPage;
import com.microsoft.graph.extensions.IOrganizationCollectionRequest;
import com.microsoft.graph.extensions.Organization;
import com.microsoft.graph.extensions.OrganizationCollectionPage;
import com.microsoft.graph.extensions.OrganizationCollectionRequest;
import com.microsoft.graph.extensions.OrganizationCollectionRequestBuilder;
import com.microsoft.graph.extensions.OrganizationRequestBuilder;
import com.microsoft.graph.generated.BaseOrganizationCollectionResponse;
import com.microsoft.graph.generated.IBaseOrganizationCollectionRequest;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class BaseOrganizationCollectionRequest
extends BaseCollectionRequest<BaseOrganizationCollectionResponse, IOrganizationCollectionPage>
implements IBaseOrganizationCollectionRequest {
    public BaseOrganizationCollectionRequest(String requestUrl, IBaseClient client, List<Option> options) {
        super(requestUrl, client, options, BaseOrganizationCollectionResponse.class, IOrganizationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOrganizationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(BaseOrganizationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOrganizationCollectionPage get() throws ClientException {
        BaseOrganizationCollectionResponse response = (BaseOrganizationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Organization newOrganization, ICallback<Organization> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OrganizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newOrganization, callback);
    }

    @Override
    public Organization post(Organization newOrganization) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OrganizationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest().post(newOrganization);
    }

    @Override
    public IOrganizationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return (OrganizationCollectionRequest)this;
    }

    @Override
    public IOrganizationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return (OrganizationCollectionRequest)this;
    }

    @Override
    public IOrganizationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return (OrganizationCollectionRequest)this;
    }

    public IOrganizationCollectionPage buildFromResponse(BaseOrganizationCollectionResponse response) {
        OrganizationCollectionRequestBuilder builder = response.nextLink != null ? new OrganizationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OrganizationCollectionPage page = new OrganizationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

